# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 7
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR7_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR7(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Round 1: Cooperate to signal willingness
    if current_round == 1:
        return "C"
    
    # Round 10: Defect unconditionally
    if current_round == 10:
        return "D"
    
    # Check if opponent always cooperates or always defects
    always_cooperate = "return 'C'" in opponent_program_code or "always cooperate" in opponent_program_code.lower()
    always_defect = "return 'D'" in opponent_program_code or "always defect" in opponent_program_code.lower()
    
    if always_cooperate:
        return "D"
    if always_defect:
        return "D"
    
    # Tit-for-Tat with forgiveness (20% chance to forgive after defection)
    if len(opp_history) > 0:
        last_opp_move = opp_history[-1]
        if last_opp_move == "D":
            if random.random() < 0.2:
                return "C"
            else:
                return "D"
        else:
            return "C"
    
    # Default to cooperate if no history (shouldn't happen)
    return "C"